% TV for TF
% a version of TV designed for displaying the output of TF (tfmann.m)
% plots the negated (to save toner) log magnitude spectrum

function returnsnothing(AA)

AAabs = abs(AA);
[M,N]=size(AA);
if max(M,N)<3; % it's probably not an image
  error('input must be a 2 dimensional image, not a vector')
end%if
clear AA
threshold = .001;  % good default threshold
AAmin = min(min(AAabs));
AAmax = max(max(AAabs));
% normalize on [0,1] to have a meaningful threshold
AAsc = (AAabs-AAmin)/(AAmax-AAmin);
clear AAabs
AAlog = log(AAsc+threshold); % easier to see on a log scale
clear AAsc

X=1:N; % time sample index
Y=-ceil((M-1)/2):floor((M-1)/2);
%tvs(flipud(-AAlog)) % need flipud because axis 'xy' also flips image
tvs(X,Y,flipud(-AAlog)) % need flipud because axis 'xy' also flips image
          %^^^^^^this -AAlog saves toner by making the image black on white
grid; xlabel('TIME'); ylabel('FREQUENCY'); axis('xy')

