 /*
 Copyright (C) 2000 James R. Bruce (jbruce@cs.cmu.edu)

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; if not, visit
   www.gnu.org/copyleft/lgpl.html
 or write to:
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA  02111-1307, USA.

 REVISION HISTORY:
   05/19/2000 - initial version (JRB)
*/

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <fcntl.h>

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

#include <termios.h>
#include <string.h>

// This is somewhat distribution-dependent, so may need to change
#define SERIAL_DEVICE "/dev/ttyS%d"

// maximum number of servos, and supported servo positioning range
#define MAX_SERVO    31
#define MAX_POSITION 254

// Errors
#define SSC_SUCCESS             (0)
#define SSC_INVALID_DEBUG_LEVEL (1)
#define SSC_CANNOT_OPEN_DEVICE  (2)
#define SSC_INVALID_BAUD_RATE   (3)
#define SSC_INVALID_PORT_NUM    (4)
#define SSC_INVALID_SERVO       (5)
#define SSC_INVALID_POSITION    (6)
#define SSC_WRITE_ERROR         (7)


/* ssc_debug_level:
   sets amount of debugging output
   0 = off
   1 = some
   2 = verbose

   returns:
     0 on sucess
     SSC_INVALID_DEBUG_LEVEL on error
*/
int ssc_debug_level(int level);

/* ssc_open:
   opens a serial port and initializes the library to control the SSC
   <port> specifies com port number, 0-3 on most systems
   <baudrate> indicates the port speed in baud

   returns:
     0 on sucess
     SSC_CANNOT_OPEN_DEVICE,
     SSC_INVALID_BAUD_RATE, or
     SSC_INVALID_PORT_NUM on error
*/
int ssc_open(int port,int baudrate);

/* ssc_move:
   moves a servo to a specified location
   <servo> identifies the servo number, 0-31
   <postition> is the target location for the servo,
       ranging from 0-255 (MAX_POSITION)

   returns:
     0 on sucess,
     SSC_INVALID_SERVO,
     SSC_INVALID_POSITION, or
     SSC_WRITE_ERROR on error
*/
int ssc_move(int servo,int position);

/* ssc_close:
   closes the serial port and deinitializes the library

   returns:
     0 on sucess
*/
int ssc_close();


/* The following aliases are provided for source level
   compatibility with the Windows version of this library
*/
#define SSC_DEBUG_LEVEL  ssc_debug_level
#define SSC_OPEN         ssc_open
#define SSC_MOVE         ssc_move
#define SSC_CLOSE        ssc_close
