%PHYSICAL EXTENT OF IMAGES about mean epoch in terms of the 0, 1 and 2  MOMENTS
% 
%dt = extent2(G); % where "G" is a matrix
%
%extent is given by: sqrt(2pi*MSE) and is independent of relative amplitude
%
%rectangular pulse has support = .7236*actual len, regardless of height
%
%extent(ones(1,100)) = extent(2*ones(1,100)) = .7236*100 pixels
%extent(ones(1,1000)) = 723.6 = .7236*1000 pixels
%
%extent is padding invariant:  extent([1 1]) = extent([0 0 0 0 1 1])
%      (both have extent ~=1.25 pixels)
%
%see Gabor, 1945
%
% note that extent2_skew([1 0 0 0;0 0 0 0;0 0 0 0;0 0 0 1]) = 0

function dxy = dum(G,forced_epoch_location);

[M N] = size(G);
[X Y] = meshdom(1:N,1:M);  % physical coordinates (meshdom>>> x like N y like M)

m0 = sum(sum(conj(G).*G));
m1 = sum(sum(conj(G).*X.*Y.*G));
if nargin > 1;
  m1 = forced_epoch_location;
end%if
m2 = sum(sum(conj(G).*X.^2..*Y.^2..*G));

Et = m1/m0;
Ett= m2/m0;

dxy = (2*pi*(Ett-Et^2)) ^ (1/2);

